@echo off
REM ****************************************************************************
REM Name    = ProSoft.cmd
REM           (c)2013 Willy Nachtigall, ProSoft GmbH, Geretsried
REM
REM Version = 1.0 => Basics ( WN 24.10.2013 )
REM ****************************************************************************
REM Zweck   = Batch Programm zum herstellen einer NetSupport Manager Verbindung
REM           zu einem CLIENT mit Hilfe von Benutzername/Passwort
REM ****************************************************************************
REM Files   = EncryptPassword.exe => Programm zum verschlüsseln eines Passwortes
REM           EncryptPassword.txt => Textdatei beinhaltet verschlüsseltes Passwort
REM           runscrip.exe        => Scriptengine zum Ausführen des Script
REM           ProSoft_Script.scp  => NetSupport Beispiel Script
REM ****************************************************************************
REM Aufruf  = ProSoft.cmd <Benutzername> <Passwort zum Verschlüsseln>
REM ****************************************************************************

REM ****************************************************************************
REM interne Variable definieren
REM ****************************************************************************

SET ENCRYPTOR_DATEI="C:\Test\EncryptPassword.exe"
SET ENCRYPTOR_OUTPUT="C:\Test\EncryptPassword.txt"
SET ENCRYPTOR_ID=12

SET SCRIPT_ENGINE="C:\Program Files (x86)\NetSupport\NetSupport Manager\runscrip.exe"
SET SCRIPT_DATEI="C:\Test\ProSoft.scp"

REM ****************************************************************************
REM übergebene Variable (Benutzername) 
REM ****************************************************************************

SET BENUTZERNAME=%1
SET PASSWORT_ORIGINAL=%2

IF NOT DEFINED BENUTZERNAME goto KeinBenutzername
IF NOT DEFINED PASSWORT_ORIGINAL goto KeinPasswort

REM ****************************************************************************
REM übergebenes Passwort verschlüsseln und für nachfolgende Verwendung speichern
REM ****************************************************************************

%ENCRYPTOR_DATEI% %ENCRYPTOR_ID% %PASSWORT_ORIGINAL% >%ENCRYPTOR_OUTPUT%

REM ****************************************************************************
REM verschlüsseltes Passwort in Umgebungsvariable schreiben
REM ****************************************************************************

SET /P ENCRYPTOR_PASSWORT=< %ENCRYPTOR_OUTPUT%

REM ****************************************************************************
REM NetSupport Script zum Verbindungsaufbau aufrufen
REM ****************************************************************************

%SCRIPT_ENGINE% %SCRIPT_DATEI% /VClientusername="%BENUTZERNAME%" /VClientPassword="%ENCRYPTOR_PASSWORT%"

GOTO Ende

REM ****************************************************************************
REM Errorhandling
REM ****************************************************************************

:KeinBenutzername
ECHO Es wurde kein Benutzername übergeben
ECHO.
GOTO Ende

:KeinPasswort
ECHO Es wurde kein Passwort übergeben
ECHO.
GOTO Ende

:Ende
PAUSE
EXIT